##
### Seção 4 - CSS3 Nive 2 - Conceitos Intermediarios e Avancados de CSS3
##

- Introdução do Módulo

##
### 81 - Introdução do Módulo
##

**Objetivo do módulo**

- Cobrir o máximo de conceitos intermédios de CSS3

**Algumas das matérias**

- Propriedades de texto, fonts, estilos, tipos de letra e alinhamentos.
- Borders, backgrounds com imagens, gradientes e outras propriedades
- Concentar atenção nos layouts: flow, floats e titos de posicionamento
- Organização dos layouts com **FlexBox**
- Organização dos layouts com **CSS Grid**
- Como criar **Media Queries** e muito mais

- sem projeto
- `Modelo - HTML, CSS, JS` Version 1
- Exemplo:
    - css_web-01 


##
### 82 - Explorando Propriedades de Texto
##


- Exemplo:
    - css_web-02


##
### 83 - Web Safe Fonts & Default Fonts
##


- Exemplo:
    - css_web-03


##
### 84 - Aplicando Sombras Nas Letras
##


- Exemplo:
    - css_web-04


##
### 85 - Usar Outro Tipo de Letras Com a Regra Font Face
##


- Exemplo:
    - css_web-05


##
### 86 - Utilização do Google Fonts
##


- Google Fonts
    Site: https://fonts.google.com/


- Exemplo:
    - css_web-06


##
### 87 - Duas Letras Distintas com Google Fonts
##

- titulo
- parágrafo

- Google Fonts
    - Site: https://fonts.google.com/

- Anton
    - Font: https://fonts.google.com/specimen/Anton?query=anto
- Genos
    - Font: https://fonts.google.com/specimen/Genos?query=Genos


- Exemplo:
    - css_web-07



##
### 88 - Alinhamento Horizontal
##


- Exemplo:
    - css_web-08

##
### 89 - Altura e Linha & Espaçamento Entre Letras e Palavras
##


- Exemplo:
    - css_web-09


##
### 90 - Usando o Text-Transform para Capitalização do Texto
##


- Exemplo:
    - css_web-10


##
### 91 - Font-Variant para Capitalizar Letras
##


- Exemplo:
    - css_web-11


##
### 92 - Aplicar Estilos a Listas
##


- Exemplo:
    - css_web-12


##
### 93 - Usando Backgrounds Nos Elementos HTML
##


- Exemplo:
    - css_web-13


##
### 94 - Criando Gerações de Cores
##


- Exemplo:
    - css_web-14



##
### 95 - Introdução aos Layouts de CSS
##


- Organização de layouts com **CSS**
- Organização dos elemento de HTML de acordo com alguns princípios
- Principal finalidade: **layouts responsivos**

**RESPONSIVIDADE**

- Ajustamento automático de layouts e conteúdo
- Vasto conjunto de propriedades para esta finalidade

**O CSS dispõe das seguintes áreas**

- Normal flow
- Propriedade display
- Floats
- Positioning
- Table layout
- Multiple-column layout
- Flexbox
- CSS Grid


- Exemplo:
    - css_web-15


##
### 96 - A Propriedade Display
##


- Propriedade display


- Exemplo:
    - css_web-16

##
### 97 - Floats
##


- Floats


- Exemplo:
    - css_web-17



##
### 98 - Posicionamento
##

- Positioning
- Posicionamento Relativo
- Posicionamento Absoluto

- Exemplo:
    - css_web-18


##
### 99 - Z-Index, Fixed & Sticky
##

- Exemplo:
    - css_web-19


##
### 100 - FlexBox Introdução
##

**Objetivo do FlexBox**

- Forma mais eficiente de organização do layout em CSS
- Organização dos elementos HTML no espaço
- Ajustamentos de elementos dentro de um **Container**
- Funcionalidades automáticas de responsividade
- É um modelo unidirecional


- Sem projeto
- `Modelo - HTML, CSS, JS` Version 2
- Exemplo:
    - css_web-20


##
### 101 - FlexBox Flex Container - Parte 1 de 3
##


- Exemplo:
    - css_web-21

##
### 102 - FlexBox Flex Container - Parte 2 de 3
##


- Exemplo:
    - css_web-22


##
### 103 - FlexBox Flex Container - Parte 3 de 3
##


- Exemplo:
    - css_web-23


##
### 104 - FlexBox Propriedades Dos Flex-Items
##

- Exemplo:
    - css_web-24


##
### 105 - Exercício 1 de FlexBox
##

- Exemplo:
    - css_web-24-exercicio1


##
### 106 - Exercício 2 de FlexBox
##


<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/exercicio02.jpg" width="80%">
</p>


- Exemplo:
    - css_web-24-exercicio2


##
### 107 - Exercício 3 de FlexBox
##


<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/login-form-exercicio3.jpg" width="80%">
</p>


- Exemplo:
    - css_web-24-exercicio3

##
### 108 - CSS Grid Introdução
##


- Introdução ao CSS Grid

**O que é o CSS Grid Layout?**

- Modelo bidimensional
- Módulo para layouts que resolve problemas antigos
- Vamos explorar conceitos e deixar de lado retro compatibilidade
- Desde Março de 2017, os browsers estão preparados
- Elemento principal: **Grid Container**
- É um dos mais poderosos módulos de CSS criados até agora



- Sem projeto
- `Modelo - HTML, CSS, JS` Version 1, e 2
- Exemplo:
    - css_web-25


##
### 109 - CSS Grid Container
##


- Exemplo:
    - css_web-26


##
### 110 - CSS Grid Template Rows & Columns
##


- Exemplo:
    - css_web-27

##
### 111 - CSS Grid Template Areas
##


- Exemplo:
    - css_web-28


##
### 112 - CSS Grid Row & Column Start End
##


- Exemplo:
    - css_web-29


##
### 113 - CSS Grid Grid Template
##


- Exemplo:
    - css_web-30


##
### 114 - CSS Grid  Espaço Entre Areas com Propriedades Gap
##


- Exemplo:
    - css_web-31


##
### 115 - CSS Grid Justify Items & Align Items
##


- Exemplo:
    - css_web-32


##
### 116 - CSS Grid Justify Content Align Content & Place Content
##


- Exemplo:
    - css_web-33


##
### 117 - CSS Grid Outras Propriedades
##

**Outras Propriedades do Grid CSS**

- Auto-columns e auto-rows (**grid-auto-columns** e **grid-auto-rows**)
- **grid- auto-flow**: row, column ou dense
- Vamos recapitular propriedades dos grid items e contruir exercícios práticos de consolidação

- Sem projeto
- `Modelo HTML CSS JS Básico` `v1` `v2`
- Exemplo:
    - css_web-34



##
### 118 - CSS Grid Recapitulando Propriedades Dos Grid Items
##


- Exemplo:
    - css_web-35


##
### 119 - CSS Grid Exercício 1
##

<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/css-grid-exercicio-1.jpg" width="80%">
</p>

- Exemplo:
    - css_web-36-exercicio1

##
### 120 - CSS Grid Exercício 2
##

<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/css_grid_reference_exercicio_2.jpg" width="80%">
</p>

- Exemplo:
    - css_web-36-exercicio2


##
### 121 - CSS Grid Exercício 3
##

<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/css_grid_reference_exercicio_3.jpg" width="80%">
</p>

- Exemplo:
    - css_web-36-exercicio3




##
### 122 - Media Queries Introdução
##

**Introdução a Media Queries**

**O que são as Media Queries?**

- Foram introduzidas no CSS3
- **Objetivo**: condicionar aplicação de regras de CSS
- **Principal aplicação**: tornar os sites **responsivos**


**O que é responsividade?**

- A mesma aplicação, Adaptação automatica


<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/responsividade-img.jpg" width="60%">
</p>


- Sem projeto
- `Modelo HTML CSS JS Básico` `v1` `v2`
- Exemplo:
    - css_web-37




##
### 123 - Media Queries Sintaxe Base
##


- Exemplo:
    - css_web-38

##
### 124 - Media Queries Mobile First
##

**Media Types**

- screen, speech, print, all

**Mobile First?**

- Pensar o CSS primeiro para mobile
- Usar Media Queries para os tamanhos maiores

- Exemplo:
    - css_web-39



##
### 125 - Media Queries Screen Breaking Points
##

**Media Queries Screen Breaking Points**

- Existe uma tabela de referência de breakpoints?

<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/media-queries-screens-img.jpg" width="80%">
</p>

- Não Existe

<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/responsive-web-designer.jpg" width="80%">
</p>

- Breakpoints Bootstrap

<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/bootstrap.jpg" width="50%">
</p>

- Breakpoints Tailwindcss

<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/tailwindcss.jpg" width="50%">
</p>

- Uma proposta mais ou menos coerente (sempre discutível)

<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/tamanhos-telas-web.jpg" width="80%">
</p>


- Sem projeto
- `Modelo HTML CSS JS Básico` `v1` `v2`
- Exemplo:
    - css_web-40


##
### 126 - Media Queries Exemplo com os Breakpoints
##


- Exemplo:
    - css_web-41


##
### 127 - Media Queries Outro Exemplo
##

- Conteúdo diferente para cada dispositivo
    - Apenas em Mobile
    - Apenas em Tablet
    - Apenas em Desktop


- Exemplo:
    - css_web-42



##
### 128 - Media Queries Orientation
##


**Orientation**

- Não vamos explorar detalhes aprofundados
- Exemplos são suficientes para percerber o sistema
- Formado vertical (**portraid**)
- Formado horizontal (**landscape**)


<p align="center">
  <img alt="...." src="../Seção 4 - CSS3 Nível 2 - Conceitos Intermediarios e Avancados de CSS3/assets/portrait-landscope.jpg" width="60%">
</p>

- Exemplo:
    - css_web-43


##
### 129 - Media Queries Print
##

- Exemplo:
    - css_web-44


##
### 130 - Media Queries Exemplo Final
##

- W3Schools
    - site: https://www.w3schools.com/css/tryit.asp?filename=tryresponsive_col-s

- Exemplo:
    - css_web-45



##
### 131 - CSS o que Ficou por Dizer
##


**O que Ficou por Dizer**

- Seletores avançados
- Funções no CSS
- Variáveis
- Animações
- Mais sobre media queries
- Pré-processadores de CSS
- E muito mais...



- Sem projeto
- `Modelo HTML CSS JS Básico` `v1` `v2`
- Exemplo:
    - css_web-46